﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NovelInterpreter.Exception
{
	/// <summary>
	/// 構文番号が範囲外の時に投げられる例外
	/// </summary>
	class ConstructionNumberOutOfRangeException : System.Exception
	{
		public ConstructionNumberOutOfRangeException() { }

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="number">番号</param>
		/// <param name="message">メッセージ</param>
		public ConstructionNumberOutOfRangeException(int number, string message)
			: base(message)
		{
			Console.WriteLine("構文番号：" + number);
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="number">番号</param>
		public ConstructionNumberOutOfRangeException(int number)
			: base("構文番号が範囲外です")
		{
			Console.WriteLine("構文番号：" + number);
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="number">番号</param>
		/// <param name="max">最大値</param>
		public ConstructionNumberOutOfRangeException(int number, int max)
			: base("構文番号が範囲外です")
		{
			Console.WriteLine("構文番号：" + number);
			Console.WriteLine("最大値：" + max);
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="number">番号</param>
		/// <param name="max">最大値</param>
		/// <param name="message">メッセージ</param>
		public ConstructionNumberOutOfRangeException(int number, int max, string message)
			: base(message)
		{
			Console.WriteLine("構文番号：" + number);
			Console.WriteLine("最大値：" + max);
		}
	}
}
